IF  NOT EXISTS (SELECT * FROM sys.objects 
					WHERE object_id = OBJECT_ID(N'[dbo].[EST_PED_ELTR_COT_FORN]') 
					AND type in (N'U')) 
begin

	CREATE TABLE [dbo].[EST_PED_ELTR_COT_FORN]([CD_FORN] [int] NOT NULL,
												[CD_PROD] [int] NOT NULL, 
												[QTDE] [money] NOT NULL,
												[VLR_CUSTO] [money] NOT NULL,
												[PERC_DESC] [money] NOT NULL,
												[CD_USU] [int] NOT NULL,
												[DT_CAD] [datetime] NOT NULL,
	CONSTRAINT [PK_EST_PED_ELTR_COT_FORN] PRIMARY KEY CLUSTERED 
	([CD_USU],[CD_FORN],[CD_PROD] ) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, 
											IGNORE_DUP_KEY = OFF, 
											ALLOW_ROW_LOCKS = ON, 
											ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
	) ON [PRIMARY]
	
	ALTER TABLE [dbo].[EST_PED_ELTR_COT_FORN] ADD  CONSTRAINT [DF_EST_PED_ELTR_COT_FORN_CD_FORN]  DEFAULT ((0)) FOR [CD_FORN] 
	ALTER TABLE [dbo].[EST_PED_ELTR_COT_FORN] ADD  CONSTRAINT [DF_EST_PED_ELTR_COT_FORN_CD_PROD]  DEFAULT ((0)) FOR [CD_PROD] 
	ALTER TABLE [dbo].[EST_PED_ELTR_COT_FORN] ADD  CONSTRAINT [DF_EST_PED_ELTR_COT_FORN_QTDE]		DEFAULT ((0)) FOR [QTDE] 
	ALTER TABLE [dbo].[EST_PED_ELTR_COT_FORN] ADD  CONSTRAINT [DF_EST_PED_ELTR_COT_FORN_VLR_CUSTO]  DEFAULT ((0)) FOR [VLR_CUSTO] 
	ALTER TABLE [dbo].[EST_PED_ELTR_COT_FORN] ADD  CONSTRAINT [DF_EST_PED_ELTR_COT_FORN_PERC_DESC]  DEFAULT ((0)) FOR [PERC_DESC] 
	ALTER TABLE [dbo].[EST_PED_ELTR_COT_FORN] ADD  CONSTRAINT [DF_EST_PED_ELTR_COT_FORN_DT_CAD]  DEFAULT (getdate()) FOR [DT_CAD]

end